#include <bits/stdc++.h>

using namespace std;

struct segtree {
    struct node {
        int set, sum, len;
    };

    int n;
    vector<node> tree;

    void build(vector<int>& a) {
        n = 1;
        while (n < a.size()) {
            n *= 2;
        }
        tree.assign(n * 2, {-1, 0, 1});
        for (int i = 0; i < a.size(); ++i) {
            tree[i + n - 1].set = -1;
            tree[i + n - 1].sum = a[i];
        }
        for (int i = n - 2; i >= 0; --i) {
            tree[i].len = tree[i * 2 + 1].len + tree[i * 2 + 2].len;
            tree[i].sum = tree[i * 2 + 1].sum + tree[i * 2 + 2].sum;
        }
    }

    void propagate(int x) {
        if (x >= n - 1) {
            return;
        }
        if (tree[x].set != -1) {
            tree[x * 2 + 1].set = tree[x].set;
            tree[x * 2 + 1].sum = tree[x].set * tree[x * 2 + 1].len;
            tree[x * 2 + 2].set = tree[x].set;
            tree[x * 2 + 2].sum = tree[x].set * tree[x * 2 + 2].len;
            tree[x].sum = tree[x * 2 + 1].sum + tree[x * 2 + 2].sum;
        }
    }

    void set(int l, int r, int val, int x, int lx, int rx) {
        propagate(x);
        if (lx > r || rx < l) {
            return;
        }
        if (l <= lx && rx <= r) {
            tree[x].set = val;
            tree[x].sum = tree[x].set * tree[x].len;
            return;
        }
        set(l, r, val, x * 2 + 1, lx, (lx + rx) / 2);
        set(l, r, val, x * 2 + 2, (lx + rx) / 2 + 1, rx);
        tree[x].sum = tree[x * 2 + 1].sum + tree[x * 2 + 2].sum;
    }

    void set(int l, int r, int val) {
        set(l, r, val, 0, 0, n - 1);
    }

    int get(int l, int r, int x, int lx, int rx) {
        propagate(x);
        if (lx > r || rx < l) {
            return 0;
        }
        if (l <= lx && rx <= r) {
            return tree[x].sum;
        }
        int a = get(l, r, x * 2 + 1, lx, (lx + rx) / 2);
        int b = get(l, r, x * 2 + 2, (lx + rx) / 2 + 1, rx);
        return a + b;
    }

    int get(int l, int r) {
        return get(l, r, 0, 0, n - 1);
    }
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, m;
    cin >> n >> m;
    string s;
    cin >> s;
    segtree st;
    vector<int> v(s.size());
    for (int i = 0; i < v.size(); ++i) {
        v[i] = s[i] == 'a';
    }
    st.build(v);
    while (m--) {
        int k;
        char a, b;
        cin >> k >> a >> b;
        if (a == 'a') {
            int left = -1, right = n - 1;
            while (left + 1 < right) {
                int mid = (left + right) / 2;
                if (st.get(0, mid) < k) {
                    left = mid;
                } else {
                    right = mid;
                }
            }
            st.set(0, right, 0);
        } else {
            int left = -1, right = n - 1;
            while (left + 1 < right) {
                int mid = (left + right) / 2;
                if (mid + 1 - st.get(0, mid) < k) {
                    left = mid;
                } else {
                    right = mid;
                }
            }
            st.set(0, right, 1);
        }
    }
    for (int i = 0; i < s.size(); ++i) {
        cout << (st.get(i, i) ? 'a' : 'b');
    }
    return 0;
}
